/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.StringSource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class LogDebugBodyStreamsTest
extends ContextTestSupport {
    public void testLogBodyStreamStringSourceDisabled() throws Exception {
        this.context.getProperties().put("CamelLogDebugStreams", "false");
        StringSource body = new StringSource("<?xml version=\"1.0\"?><person><name>Claus</name></person>");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        String msg = ((Exchange)mock.getReceivedExchanges().get(0)).getIn().toString();
        LogDebugBodyStreamsTest.assertEquals((String)"Message: <?xml version=\"1.0\"?><person><name>Claus</name></person>", (String)msg);
    }

    public void testLogBodyStreamStringSourceDisabledByDefault() throws Exception {
        this.context.getProperties().remove("CamelLogDebugStreams");
        StringSource body = new StringSource("<?xml version=\"1.0\"?><person><name>Claus</name></person>");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        String msg = ((Exchange)mock.getReceivedExchanges().get(0)).getIn().toString();
        LogDebugBodyStreamsTest.assertEquals((String)"Message: <?xml version=\"1.0\"?><person><name>Claus</name></person>", (String)msg);
    }

    public void testLogBodyStreamStringSourceEnabled() throws Exception {
        this.context.getProperties().put("CamelLogDebugStreams", "true");
        StringSource body = new StringSource("<?xml version=\"1.0\"?><person><name>Claus</name></person>");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        String msg = ((Exchange)mock.getReceivedExchanges().get(0)).getIn().toString();
        LogDebugBodyStreamsTest.assertEquals((String)"Message: <?xml version=\"1.0\"?><person><name>Claus</name></person>", (String)msg);
    }

    public void testLogBodyStreamDisabled() throws Exception {
        this.context.getProperties().put("CamelLogDebugStreams", "false");
        ByteArrayInputStream body = new ByteArrayInputStream("Hello World".getBytes());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        String msg = ((Exchange)mock.getReceivedExchanges().get(0)).getIn().toString();
        LogDebugBodyStreamsTest.assertEquals((String)"Message: [Body is instance of java.io.InputStream]", (String)msg);
    }

    public void testLogBodyStreamDisabledByDefault() throws Exception {
        this.context.getProperties().remove("CamelLogDebugStreams");
        ByteArrayInputStream body = new ByteArrayInputStream("Hello World".getBytes());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        String msg = ((Exchange)mock.getReceivedExchanges().get(0)).getIn().toString();
        LogDebugBodyStreamsTest.assertEquals((String)"Message: [Body is instance of java.io.InputStream]", (String)msg);
    }

    public void testLogBodyStreamEnabled() throws Exception {
        this.context.getProperties().put("CamelLogDebugStreams", "true");
        ByteArrayInputStream body = new ByteArrayInputStream("Hello World".getBytes());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
        String msg = ((Exchange)mock.getReceivedExchanges().get(0)).getIn().toString();
        LogDebugBodyStreamsTest.assertNotSame((Object)"Message: [Body is instance of java.io.InputStream]", (Object)msg);
        LogDebugBodyStreamsTest.assertIsInstanceOf(InputStream.class, ((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).to("mock:result");
            }
        };
    }
}

