/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class RouteSedaSuspendResumeTest
extends ContextTestSupport {
    public void testSuspendResume() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"A"});
        this.template.sendBody("seda:foo", (Object)"A");
        this.assertMockEndpointsSatisfied();
        this.log.info("Suspending");
        this.resetMocks();
        mock.expectedMessageCount(0);
        this.context.suspendRoute("foo");
        RouteSedaSuspendResumeTest.assertEquals((String)"Suspended", (String)this.context.getRouteStatus("foo").name());
        this.template.sendBody("seda:foo", (Object)"B");
        mock.assertIsSatisfied(1000L);
        this.log.info("Resuming");
        this.resetMocks();
        mock.expectedBodiesReceived(new Object[]{"B"});
        this.context.resumeRoute("foo");
        this.assertMockEndpointsSatisfied();
        RouteSedaSuspendResumeTest.assertEquals((String)"Started", (String)this.context.getRouteStatus("foo").name());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:foo").routeId("foo").to("log:foo")).to("mock:result");
            }
        };
    }
}

