/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.RouteBuilder;

public class AdviceWithRouteScopedErrorHandlerIssueTest
extends ContextTestSupport {
    public void testAdviceWith() throws Exception {
        this.context.getRouteDefinition("route-a").adviceWith(this.context, (RouteBuilder)new AdviceWithRouteBuilder(){

            public void configure() throws Exception {
                this.interceptSendToEndpoint("direct:bar").skipSendToOriginalEndpoint().throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").routeId("route-a").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error")).to("direct:bar");
                this.from("direct:bar").routeId("route-b").to("mock:bar");
            }
        };
    }
}

