/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;

public class CBRConcurrencyIssueTest
extends ContextTestSupport {
    public void testCBRConcurrencyIssue() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:other").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBodyAndHeader("seda:start", (Object)"Hello World", "foo", (Object)"send");
        this.template.sendBodyAndHeader("seda:start", (Object)"Bye World", "foo", (Object)"receive");
        this.assertMockEndpointsSatisfied();
    }

    public void testCBRConcurrencyManyMessagesIssue() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(50);
        this.getMockEndpoint("mock:other").expectedMessageCount(150);
        for (int i = 0; i < 200; ++i) {
            if (i % 4 == 0) {
                this.template.sendBodyAndHeader("seda:start", (Object)"Hello World", "foo", (Object)"send");
                continue;
            }
            this.template.sendBodyAndHeader("seda:start", (Object)"Bye World", "foo", (Object)"receive");
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((RouteDefinition)this.from("seda:start?concurrentConsumers=10").log("Got foo ${header.foo} header")).choice().when(this.header("foo").isEqualTo((Object)"send")).to("mock:result")).when(this.header("foo").isEqualTo((Object)"receive")).to("mock:other");
            }
        };
    }
}

