/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;

public class CBRContainsIssueTest
extends ContextTestSupport {
    public void testNot13() throws Exception {
        this.getMockEndpoint("mock:13").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testIs13() throws Exception {
        this.getMockEndpoint("mock:13").expectedMessageCount(1);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"13");
        this.assertMockEndpointsSatisfied();
    }

    public void testIs13Number() throws Exception {
        this.getMockEndpoint("mock:13").expectedMessageCount(1);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)13);
        this.assertMockEndpointsSatisfied();
    }

    public void testContains13() throws Exception {
        this.getMockEndpoint("mock:13").expectedMessageCount(1);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hi 13 how are you?");
        this.assertMockEndpointsSatisfied();
    }

    public void testContains13Number() throws Exception {
        this.getMockEndpoint("mock:13").expectedMessageCount(1);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)221344);
        this.assertMockEndpointsSatisfied();
    }

    public void testContainsNot13Number() throws Exception {
        this.getMockEndpoint("mock:13").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)22);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)this.from("direct:start").choice().when(this.body().convertToString().contains((Object)"13")).to("mock:13")).otherwise().to("mock:other");
            }
        };
    }
}

