/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.io.IOException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class ContextScopedOnExceptionNotHandledErrorHandlerRefIssueTwoRoutesTest
extends ContextTestSupport {
    public void testOnExceptionErrorHandlerRef() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:handled").expectedMessageCount(1);
        this.getMockEndpoint("mock:dead").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            ContextScopedOnExceptionNotHandledErrorHandlerRefIssueTwoRoutesTest.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            IllegalArgumentException cause = ContextScopedOnExceptionNotHandledErrorHandlerRefIssueTwoRoutesTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            ContextScopedOnExceptionNotHandledErrorHandlerRefIssueTwoRoutesTest.assertEquals((String)"Damn", (String)cause.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testOnExceptionErrorHandlerRefFoo() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(0);
        this.getMockEndpoint("mock:handled").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello Foo");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myDLC", (Object)new DeadLetterChannelBuilder("mock:dead"));
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)new ErrorHandlerBuilderRef("myDLC"));
                ((OnExceptionDefinition)this.onException(IllegalArgumentException.class).handled(false).to("mock:handled")).end();
                ((RouteDefinition)this.from("direct:foo").to("mock:foo")).throwException((Exception)new IOException("Damn IO"));
                ((RouteDefinition)this.from("direct:start").to("mock:a")).throwException((Exception)new IllegalArgumentException("Damn"));
            }
        };
    }
}

