/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.processor.aggregate.AggregationStrategy;

public class MulticastSingleAggregateIssueTest
extends ContextTestSupport {
    public void testMulticastSingleAggregateIssue() throws Exception {
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{2});
        this.getMockEndpoint("mock:a").expectedHeaderReceived("foo", (Object)"I was here");
        this.template.sendBody("direct:a", (Object)1);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.from("direct:a").multicast((AggregationStrategy)new SumAggregateBean()).to("direct:foo")).end().to("mock:a");
                this.from("direct:foo").bean(IncreaseOne.class);
            }
        };
    }

    public static class SumAggregateBean
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            newExchange.getIn().setHeader("foo", (Object)"I was here");
            if (oldExchange == null) {
                return newExchange;
            }
            int num1 = (Integer)oldExchange.getIn().getBody(Integer.TYPE);
            int num2 = (Integer)newExchange.getIn().getBody(Integer.TYPE);
            newExchange.getIn().setHeader("foo", (Object)"I was here");
            newExchange.getIn().setBody((Object)(num1 + num2));
            return newExchange;
        }
    }

    public static class IncreaseOne {
        public int addOne(int num) {
            return num + 1;
        }
    }
}

