/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;

public class RecipientListUseOriginalMessageIssueTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        RecipientListUseOriginalMessageIssueTest.deleteDirectory("target/inbox");
        RecipientListUseOriginalMessageIssueTest.deleteDirectory("target/outbox");
        super.setUp();
    }

    public void testRecipientListUseOriginalMessageIssue() throws Exception {
        this.getMockEndpoint("mock:error").expectedMinimumMessageCount(1);
        this.template.sendBodyAndHeader("file:target/inbox", (Object)"A", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        File out = new File("target/outbox/hello.txt");
        String data = (String)this.context.getTypeConverter().convertTo(String.class, (Object)out);
        RecipientListUseOriginalMessageIssueTest.assertEquals((String)"A", (String)data);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).useOriginalMessage().to("file://target/outbox")).to("mock:error");
                ((RouteDefinition)((RouteDefinition)this.from("file://target/inbox").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getIn().setBody((Object)"B");
                    }
                })).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getIn().setHeader("path", (Object)"xxx");
                    }
                })).recipientList((Expression)this.header("path"));
            }
        };
    }
}

