/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class SplitterCorrelationIdIssueTest
extends ContextTestSupport {
    public void testSplitCorrelationId() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedMessageCount(3);
        Exchange exchange = this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"A,B,C");
            }
        });
        this.assertMockEndpointsSatisfied();
        String parent = exchange.getExchangeId();
        String split1 = ((Exchange)mock.getReceivedExchanges().get(0)).getExchangeId();
        String split2 = ((Exchange)mock.getReceivedExchanges().get(1)).getExchangeId();
        String split3 = ((Exchange)mock.getReceivedExchanges().get(2)).getExchangeId();
        SplitterCorrelationIdIssueTest.assertNotSame((Object)parent, (Object)split1);
        SplitterCorrelationIdIssueTest.assertNotSame((Object)parent, (Object)split2);
        SplitterCorrelationIdIssueTest.assertNotSame((Object)parent, (Object)split3);
        SplitterCorrelationIdIssueTest.assertNotSame((Object)split1, (Object)split2);
        SplitterCorrelationIdIssueTest.assertNotSame((Object)split2, (Object)split3);
        SplitterCorrelationIdIssueTest.assertNotSame((Object)split3, (Object)split1);
        String corr1 = (String)((Exchange)mock.getReceivedExchanges().get(0)).getProperty("CamelCorrelationId", String.class);
        String corr2 = (String)((Exchange)mock.getReceivedExchanges().get(1)).getProperty("CamelCorrelationId", String.class);
        String corr3 = (String)((Exchange)mock.getReceivedExchanges().get(2)).getProperty("CamelCorrelationId", String.class);
        SplitterCorrelationIdIssueTest.assertEquals((String)parent, (String)corr1);
        SplitterCorrelationIdIssueTest.assertEquals((String)parent, (String)corr2);
        SplitterCorrelationIdIssueTest.assertEquals((String)parent, (String)corr3);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").split((Expression)this.body().tokenize(",")).to("mock:split");
            }
        };
    }
}

