/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.MulticastDefinition;

public class SplitterThrowExceptionInExpressionTwoTest
extends ContextTestSupport {
    public void testSplitterAndVerifyMock() throws Exception {
        this.getMockEndpoint("mock:cast1").expectedMessageCount(1);
        this.getMockEndpoint("mock:cast2").expectedMessageCount(0);
        this.getMockEndpoint("mock:cast3").expectedMessageCount(0);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"A,B,C");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((MulticastDefinition)this.from("direct:start").errorHandler((ErrorHandlerFactory)this.deadLetterChannel("mock:error").disableRedelivery()).multicast().stopOnException().streaming().to("mock:cast1")).split((Expression)new MyExpression()).stopOnException().streaming().to("mock:cast2")).end().to("mock:cast3").end().to("mock:result");
            }
        };
    }

    private static class MyExpression
    implements Expression {
        private MyExpression() {
        }

        public <T> T evaluate(Exchange exchange, Class<T> type) {
            throw new ExpressionEvaluationException(null, exchange, null);
        }
    }
}

