/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.issues;

import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.converter.StaticMethodTypeConverter;
import org.apache.camel.issues.MyCamelBean;
import org.apache.camel.util.StopWatch;

public class TypeConverterConcurrencyIssueTest
extends ContextTestSupport {
    private int size = 100000;

    public void testTypeConverter() throws Exception {
        Method method = TypeConverterConcurrencyIssueTest.class.getMethod("toMyCamelBean", String.class);
        TypeConverterConcurrencyIssueTest.assertNotNull((Object)method);
        this.context.getTypeConverterRegistry().addTypeConverter(MyCamelBean.class, String.class, (TypeConverter)new StaticMethodTypeConverter(method));
        ExecutorService pool = this.context.getExecutorServiceManager().newThreadPool((Object)this, "test", 50, 50);
        final CountDownLatch latch = new CountDownLatch(this.size);
        StopWatch watch = new StopWatch();
        for (int i = 0; i < this.size; ++i) {
            pool.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        TypeConverterConcurrencyIssueTest.this.context.getTypeConverter().mandatoryConvertTo(MyCamelBean.class, (Object)"1;MyCamel");
                        latch.countDown();
                    }
                    catch (NoTypeConversionAvailableException noTypeConversionAvailableException) {
                        // empty catch block
                    }
                }
            });
        }
        TypeConverterConcurrencyIssueTest.assertTrue((String)"The expected mandatory conversions failed!", (boolean)latch.await(1L, TimeUnit.MINUTES));
        this.log.info("Took " + watch.stop() + " millis to convert " + this.size + " objects");
    }

    public static MyCamelBean toMyCamelBean(String body) {
        MyCamelBean bean = new MyCamelBean();
        String[] data = body.split(";");
        bean.setId(Integer.parseInt(data[0]));
        bean.setName(data[1]);
        return bean;
    }
}

