/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;

public class SimpleOgnlMapIssueTest
extends ContextTestSupport {
    public void testSimpleOgnlIssueKing() throws Exception {
        this.getMockEndpoint("mock:king").expectedMessageCount(1);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        MyObjectMessage body = new MyObjectMessage();
        body.getProperty().put("foo", "King Kong");
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
    }

    public void testSimpleOgnlIssueOther() throws Exception {
        this.getMockEndpoint("mock:king").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        MyObjectMessage body = new MyObjectMessage();
        body.getProperty().put("foo", "Tiger");
        this.template.sendBody("direct:start", (Object)body);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when().simple("${body.property['foo']} == 'King Kong'")).to("mock:king")).otherwise().to("mock:other");
            }
        };
    }

    public static final class MyObjectMessage {
        private Map<Object, Object> property = new HashMap<Object, Object>();

        public Map<Object, Object> getProperty() {
            return this.property;
        }
    }
}

