/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;

public class XPathRouteConcurrentTest
extends ContextTestSupport {
    public void testXPathNotConcurrent() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.template.sendBody("seda:foo", (Object)"<person><name>Claus</name></person>");
        this.assertMockEndpointsSatisfied();
    }

    public void testXPathTwoMessages() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"<person><name>Claus</name></person>");
        this.template.sendBody("seda:foo", (Object)"<person><name>James</name></person>");
        this.assertMockEndpointsSatisfied();
    }

    public void testXPathTwoMessagesNotSameTime() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"<person><name>Claus</name></person>");
        Thread.sleep(100L);
        this.template.sendBody("seda:foo", (Object)"<person><name>James</name></person>");
        this.assertMockEndpointsSatisfied();
    }

    public void testNoConcurrent() throws Exception {
        this.doSendMessages(1);
    }

    public void testConcurrent() throws Exception {
        this.doSendMessages(10);
    }

    private void doSendMessages(int files) throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(files);
        this.getMockEndpoint("mock:result").expectsNoDuplicates((Expression)XPathRouteConcurrentTest.body());
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        for (int i = 0; i < files; ++i) {
            this.template.sendBody("seda:foo", (Object)("<person><id>" + i + "</id><name>Claus</name></person>"));
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("seda:foo?concurrentConsumers=10").choice().when().xpath("/person/name = 'Claus'")).to("mock:result")).otherwise().to("mock:other")).end();
            }
        };
    }
}

