/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.LanguageTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.language.simple.SimplePredicateParser;

public class SimpleBackwardsCompatibleTest
extends LanguageTestSupport {
    @Override
    protected String getLanguageName() {
        return "simple";
    }

    public void testSimpleBody() throws Exception {
        this.assertExpression(this.exchange, "${body}", (Object)"<hello id='m123'>world!</hello>");
        this.assertExpression(this.exchange, "$simple{body}", (Object)"<hello id='m123'>world!</hello>");
        this.assertExpression(this.exchange, "body", (Object)"<hello id='m123'>world!</hello>");
        this.assertPredicate("${body}", true);
        this.assertPredicate("body", true);
    }

    public void testSimpleHeader() throws Exception {
        this.exchange.getIn().setHeader("foo", (Object)123);
        this.assertExpression(this.exchange, "${header.foo}", 123);
        this.assertExpression(this.exchange, "header.foo", 123);
        this.assertPredicate("${header.foo}", true);
        this.assertPredicate("header.foo", true);
        this.assertPredicate("${header.unknown}", false);
        this.assertPredicate("header.unknown", false);
    }

    public void testSimpleLogicalAnd() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("high", (Object)true);
        this.exchange.getIn().setHeader("foo", (Object)123);
        SimplePredicateParser parser = new SimplePredicateParser("${header.high} == true and ${header.foo} == 123", true);
        Predicate pre = parser.parsePredicate();
        SimpleBackwardsCompatibleTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
    }

    public void testSimpleLogicalOr() throws Exception {
        this.exchange.getIn().setBody((Object)"Hello");
        this.exchange.getIn().setHeader("high", (Object)true);
        this.exchange.getIn().setHeader("foo", (Object)123);
        SimplePredicateParser parser = new SimplePredicateParser("${header.high} == false or ${header.foo} == 123", true);
        Predicate pre = parser.parsePredicate();
        SimpleBackwardsCompatibleTest.assertTrue((String)"Should match", (boolean)pre.matches(this.exchange));
    }
}

