/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import org.apache.camel.LanguageTestSupport;

public class SimpleWhiteSpaceTest
extends LanguageTestSupport {
    @Override
    protected String getLanguageName() {
        return "simple";
    }

    public void testExpressionWithSpace() {
        this.exchange.getIn().setBody((Object)"some text");
        this.assertPredicate("${in.body} contains 'some' and ${in.body} contains 'text'", true);
    }

    public void testExpressionWithTabs() {
        this.exchange.getIn().setBody((Object)"some text");
        this.assertPredicate("${in.body} contains 'some' and\t${in.body} contains 'text'", true);
    }

    public void testUnixMultiLineExpression() {
        this.exchange.getIn().setBody((Object)"some text");
        this.assertPredicate("${in.body} contains 'some' and\n${in.body} contains 'text'", true);
    }

    public void testWindowsMultiLineExpression() {
        this.exchange.getIn().setBody((Object)"some text");
        this.assertPredicate("${in.body} contains 'some' and\r\n${in.body} contains 'text'", true);
    }

    public void testMacMultiLineExpression() {
        this.exchange.getIn().setBody((Object)"some text");
        this.assertPredicate("${in.body} contains 'some' and\r${in.body} contains 'text'", true);
    }

    public void testExpressionWithMultiLineString() {
        this.exchange.getIn().setBody((Object)"\tsome\nmulti\rline\r\ntext");
        this.assertPredicate("${in.body} == '\tsome\nmulti\rline\r\ntext'", true);
    }
}

