/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.rest.DummyRestConsumerFactory;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.SimpleRegistry;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.spi.Registry;

public class ManagedFromRestGetTest
extends ManagementTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        SimpleRegistry registry = new SimpleRegistry();
        registry.put((Object)"dummy-test", (Object)new DummyRestConsumerFactory());
        return new DefaultCamelContext((Registry)registry);
    }

    public void testFromRestModel() throws Exception {
        if (ManagedFromRestGetTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=context,name=\"camel-1\"");
        String xml = (String)mbeanServer.invoke(on, "dumpRestsAsXml", null, null);
        ManagedFromRestGetTest.assertNotNull((Object)xml);
        this.log.info(xml);
        ManagedFromRestGetTest.assertTrue((boolean)xml.contains("<rests"));
        ManagedFromRestGetTest.assertTrue((boolean)xml.contains("<rest path=\"/say/hello\">"));
        ManagedFromRestGetTest.assertTrue((boolean)xml.contains("<rest path=\"/say/bye\">"));
        ManagedFromRestGetTest.assertTrue((boolean)xml.contains("</rest>"));
        ManagedFromRestGetTest.assertTrue((boolean)xml.contains("<get>"));
        ManagedFromRestGetTest.assertTrue((boolean)xml.contains("application/json"));
        ManagedFromRestGetTest.assertTrue((boolean)xml.contains("<post>"));
        ManagedFromRestGetTest.assertTrue((boolean)xml.contains("application/json"));
        ManagedFromRestGetTest.assertTrue((boolean)xml.contains("</rests>"));
        String xml2 = (String)mbeanServer.invoke(on, "dumpRoutesAsXml", null, null);
        this.log.info(xml2);
        ManagedFromRestGetTest.assertTrue((boolean)xml2.contains("rest=\"true\""));
        ManagedFromRestGetTest.assertEquals((int)5, (int)this.context.getRouteDefinitions().size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.rest("/say/hello").get().to("direct:hello");
                this.rest("/say/bye").get().consumes("application/json").to("direct:bye").post().to("mock:update");
                this.from("direct:hello").transform().constant((Object)"Hello World");
                this.from("direct:bye").transform().constant((Object)"Bye World");
            }
        };
    }
}

