/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Date;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;
import org.apache.camel.model.RouteDefinition;

public class ManagedRoutePerformanceCounterTest
extends ManagementTestSupport {
    public void testPerformanceCounterStats() throws Exception {
        if (ManagedRoutePerformanceCounterTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        ObjectName on = ObjectName.getInstance("org.apache.camel:context=camel-1,type=routes,name=\"route1\"");
        Long delta = (Long)mbeanServer.getAttribute(on, "DeltaProcessingTime");
        ManagedRoutePerformanceCounterTest.assertEquals((int)0, (int)delta.intValue());
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.asyncSendBody("direct:start", (Object)"Hello World");
        Integer inFlight = null;
        for (int i = 0; i < 10; ++i) {
            Thread.sleep(500L);
            inFlight = (Integer)mbeanServer.getAttribute(on, "InflightExchanges");
            if (inFlight.longValue() == 1L) break;
        }
        ManagedRoutePerformanceCounterTest.assertNotNull((String)"too slow server", inFlight);
        ManagedRoutePerformanceCounterTest.assertEquals((long)1L, (long)inFlight.longValue());
        this.assertMockEndpointsSatisfied();
        Thread.sleep(3000L);
        Long completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedRoutePerformanceCounterTest.assertEquals((long)1L, (long)completed);
        delta = (Long)mbeanServer.getAttribute(on, "DeltaProcessingTime");
        Long last = (Long)mbeanServer.getAttribute(on, "LastProcessingTime");
        Long total = (Long)mbeanServer.getAttribute(on, "TotalProcessingTime");
        ManagedRoutePerformanceCounterTest.assertNotNull((Object)delta);
        ManagedRoutePerformanceCounterTest.assertTrue((String)("Should take around 3 sec: was " + last), (last > 2900L ? 1 : 0) != 0);
        ManagedRoutePerformanceCounterTest.assertTrue((String)("Should take around 3 sec: was " + total), (total > 2900L ? 1 : 0) != 0);
        this.template.sendBody("direct:start", (Object)"Bye World");
        completed = (Long)mbeanServer.getAttribute(on, "ExchangesCompleted");
        ManagedRoutePerformanceCounterTest.assertEquals((long)2L, (long)completed);
        delta = (Long)mbeanServer.getAttribute(on, "DeltaProcessingTime");
        last = (Long)mbeanServer.getAttribute(on, "LastProcessingTime");
        total = (Long)mbeanServer.getAttribute(on, "TotalProcessingTime");
        ManagedRoutePerformanceCounterTest.assertNotNull((Object)delta);
        ManagedRoutePerformanceCounterTest.assertTrue((String)("Should take around 3 sec: was " + last), (last > 2900L ? 1 : 0) != 0);
        ManagedRoutePerformanceCounterTest.assertTrue((String)("Should be around 5 sec now: was " + total), (total > 4900L ? 1 : 0) != 0);
        Date reset = (Date)mbeanServer.getAttribute(on, "ResetTimestamp");
        ManagedRoutePerformanceCounterTest.assertNotNull((Object)reset);
        Date lastFailed = (Date)mbeanServer.getAttribute(on, "LastExchangeFailureTimestamp");
        Date firstFailed = (Date)mbeanServer.getAttribute(on, "FirstExchangeFailureTimestamp");
        ManagedRoutePerformanceCounterTest.assertNull((Object)lastFailed);
        ManagedRoutePerformanceCounterTest.assertNull((Object)firstFailed);
        inFlight = (Integer)mbeanServer.getAttribute(on, "InflightExchanges");
        ManagedRoutePerformanceCounterTest.assertEquals((long)0L, (long)inFlight.longValue());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).delay(3000L).to("mock:result");
            }
        };
    }
}

