/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.ServiceStatus;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.ManagementTestSupport;

public class ManagedUnregisterConsumerTest
extends ManagementTestSupport {
    public void testUnregisterConsumer() throws Exception {
        if (ManagedUnregisterConsumerTest.isPlatform("aix")) {
            return;
        }
        MBeanServer mbeanServer = this.getMBeanServer();
        Set<ObjectName> set = mbeanServer.queryNames(new ObjectName("*:type=consumers,*"), null);
        ManagedUnregisterConsumerTest.assertEquals((int)1, (int)set.size());
        ObjectName on = set.iterator().next();
        ManagedUnregisterConsumerTest.assertTrue((String)"Should be registered", (boolean)mbeanServer.isRegistered(on));
        String uri = (String)mbeanServer.getAttribute(on, "EndpointUri");
        ManagedUnregisterConsumerTest.assertEquals((String)"direct://start", (String)uri);
        String routeId = (String)mbeanServer.getAttribute(on, "RouteId");
        ManagedUnregisterConsumerTest.assertEquals((String)"route1", (String)routeId);
        String camelId = (String)mbeanServer.getAttribute(on, "CamelId");
        ManagedUnregisterConsumerTest.assertEquals((String)"camel-1", (String)camelId);
        String state = (String)mbeanServer.getAttribute(on, "State");
        ManagedUnregisterConsumerTest.assertEquals((String)ServiceStatus.Started.name(), (String)state);
        this.context.stop();
        ManagedUnregisterConsumerTest.assertFalse((String)"Should no longer be registered", (boolean)mbeanServer.isRegistered(on));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

