/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;

public class CBRWithWireTapTest
extends ContextTestSupport {
    public void testCBRWithWireTapCamel() throws Exception {
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.getMockEndpoint("mock:camel").expectedMessageCount(1);
        this.getMockEndpoint("mock:donkey").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Camel rules");
        this.assertMockEndpointsSatisfied();
    }

    public void testCBRWithWireTapDonkey() throws Exception {
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.getMockEndpoint("mock:camel").expectedMessageCount(0);
        this.getMockEndpoint("mock:donkey").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Donkey kong");
        this.assertMockEndpointsSatisfied();
    }

    public void testCBRWithWireTapOther() throws Exception {
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.getMockEndpoint("mock:camel").expectedMessageCount(0);
        this.getMockEndpoint("mock:donkey").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.body().contains((Object)"Camel")).wireTap("mock:camel").end()).when(this.body().contains((Object)"Donkey")).wireTap("mock:donkey").copy().end()).otherwise().to("mock:other");
            }
        };
    }
}

