/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class CircuitBreakerLoadBalancerTest
extends ContextTestSupport {
    private MockEndpoint result;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.result = this.getMockEndpoint("mock:result");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").loadBalance().circuitBreaker(2, 1000L, new Class[]{MyCustomException.class}).to("mock:result");
                this.from("direct:start-async").loadBalance().circuitBreaker(2, 1000L, new Class[]{MyCustomException.class}).threads(1).to("mock:result");
            }
        };
    }

    public void testClosedCircuitPassesMessagesSync() throws Exception {
        String endpoint = "direct:start";
        this.closedCircuitPassesMessages(endpoint);
    }

    public void testClosedCircuitPassesMessagesAsync() throws Exception {
        String endpoint = "direct:start-async";
        this.closedCircuitPassesMessages(endpoint);
    }

    private void closedCircuitPassesMessages(String endpoint) throws InterruptedException, Exception {
        MockEndpoint.expectsMessageCount((int)3, (MockEndpoint[])new MockEndpoint[]{this.result});
        this.sendMessage(endpoint, "message one");
        this.sendMessage(endpoint, "message two");
        this.sendMessage(endpoint, "message three");
        this.assertMockEndpointsSatisfied();
    }

    public void testFailedMessagesOpenCircuitToPreventMessageThreeSync() throws Exception {
        String endpoint = "direct:start";
        this.failedMessagesOpenCircuitToPreventMessageThree(endpoint);
    }

    public void testFailedMessagesOpenCircuitToPreventMessageThreeAsync() throws Exception {
        String endpoint = "direct:start-async";
        this.failedMessagesOpenCircuitToPreventMessageThree(endpoint);
    }

    private void failedMessagesOpenCircuitToPreventMessageThree(String endpoint) throws InterruptedException, Exception {
        MockEndpoint.expectsMessageCount((int)2, (MockEndpoint[])new MockEndpoint[]{this.result});
        this.result.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setException((Throwable)new MyCustomException());
            }
        });
        Exchange exchangeOne = this.sendMessage(endpoint, "message one");
        Exchange exchangeTwo = this.sendMessage(endpoint, "message two");
        Exchange exchangeThree = this.sendMessage(endpoint, "message three");
        this.assertMockEndpointsSatisfied();
        CircuitBreakerLoadBalancerTest.assertTrue((boolean)(exchangeOne.getException() instanceof MyCustomException));
        CircuitBreakerLoadBalancerTest.assertTrue((boolean)(exchangeTwo.getException() instanceof MyCustomException));
        CircuitBreakerLoadBalancerTest.assertTrue((boolean)(exchangeThree.getException() instanceof RejectedExecutionException));
    }

    public void testHalfOpenAfterMessageThreeSync() throws Exception {
        String endpoint = "direct:start";
        this.halfOpenAfterMessageThree(endpoint);
    }

    public void testHalfOpenAfterMessageThreeAsync() throws Exception {
        String endpoint = "direct:start-async";
        this.halfOpenAfterMessageThree(endpoint);
    }

    private void halfOpenAfterMessageThree(String endpoint) throws InterruptedException, Exception {
        MockEndpoint.expectsMessageCount((int)2, (MockEndpoint[])new MockEndpoint[]{this.result});
        this.result.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setException((Throwable)new MyCustomException());
            }
        });
        Exchange exchangeOne = this.sendMessage(endpoint, "message one");
        Exchange exchangeTwo = this.sendMessage(endpoint, "message two");
        Exchange exchangeThree = this.sendMessage(endpoint, "message three");
        this.assertMockEndpointsSatisfied();
        Thread.sleep(1000L);
        this.result.reset();
        this.result.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setException((Throwable)new MyCustomException());
            }
        });
        MockEndpoint.expectsMessageCount((int)1, (MockEndpoint[])new MockEndpoint[]{this.result});
        Exchange exchangeFour = this.sendMessage(endpoint, "message four");
        Exchange exchangeFive = this.sendMessage(endpoint, "message five");
        this.assertMockEndpointsSatisfied();
        CircuitBreakerLoadBalancerTest.assertTrue((boolean)(exchangeOne.getException() instanceof MyCustomException));
        CircuitBreakerLoadBalancerTest.assertTrue((boolean)(exchangeTwo.getException() instanceof MyCustomException));
        CircuitBreakerLoadBalancerTest.assertTrue((boolean)(exchangeThree.getException() instanceof RejectedExecutionException));
        CircuitBreakerLoadBalancerTest.assertTrue((boolean)(exchangeFour.getException() instanceof MyCustomException));
        CircuitBreakerLoadBalancerTest.assertTrue((boolean)(exchangeFive.getException() instanceof RejectedExecutionException));
    }

    public void testHalfOpenToCloseTransitionSync() throws Exception {
        String endpoint = "direct:start";
        this.halfOpenToCloseTransition(endpoint);
    }

    public void testHalfOpenToCloseTransitionAsync() throws Exception {
        String endpoint = "direct:start-async";
        this.halfOpenToCloseTransition(endpoint);
    }

    private void halfOpenToCloseTransition(String endpoint) throws Exception {
        MockEndpoint.expectsMessageCount((int)2, (MockEndpoint[])new MockEndpoint[]{this.result});
        this.result.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setException((Throwable)new MyCustomException());
            }
        });
        Exchange exchangeOne = this.sendMessage(endpoint, "message one");
        Exchange exchangeTwo = this.sendMessage(endpoint, "message two");
        Exchange exchangeThree = this.sendMessage(endpoint, "message three");
        this.assertMockEndpointsSatisfied();
        Thread.sleep(1000L);
        this.result.reset();
        MockEndpoint.expectsMessageCount((int)2, (MockEndpoint[])new MockEndpoint[]{this.result});
        Exchange exchangeFour = this.sendMessage(endpoint, "message four");
        Exchange exchangeFive = this.sendMessage(endpoint, "message five");
        this.assertMockEndpointsSatisfied();
        CircuitBreakerLoadBalancerTest.assertTrue((boolean)(exchangeOne.getException() instanceof MyCustomException));
        CircuitBreakerLoadBalancerTest.assertTrue((boolean)(exchangeTwo.getException() instanceof MyCustomException));
        CircuitBreakerLoadBalancerTest.assertTrue((boolean)(exchangeThree.getException() instanceof RejectedExecutionException));
        CircuitBreakerLoadBalancerTest.assertTrue((exchangeFour.getException() == null ? 1 : 0) != 0);
        CircuitBreakerLoadBalancerTest.assertTrue((exchangeFive.getException() == null ? 1 : 0) != 0);
    }

    public void testHalfOpenCircuitClosesAfterTimeoutSync() throws Exception {
        String endpoint = "direct:start";
        this.halfOpenCircuitClosesAfterTimeout(endpoint);
    }

    public void testHalfOpenCircuitClosesAfterTimeoutAsync() throws Exception {
        String endpoint = "direct:start-async";
        this.halfOpenCircuitClosesAfterTimeout(endpoint);
    }

    private void halfOpenCircuitClosesAfterTimeout(String endpoint) throws InterruptedException, Exception {
        MockEndpoint.expectsMessageCount((int)2, (MockEndpoint[])new MockEndpoint[]{this.result});
        this.result.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setException((Throwable)new MyCustomException());
            }
        });
        this.sendMessage(endpoint, "message one");
        this.sendMessage(endpoint, "message two");
        this.sendMessage(endpoint, "message three");
        this.assertMockEndpointsSatisfied();
        this.result.reset();
        MockEndpoint.expectsMessageCount((int)1, (MockEndpoint[])new MockEndpoint[]{this.result});
        Thread.sleep(1000L);
        this.sendMessage(endpoint, "message four");
        this.assertMockEndpointsSatisfied();
    }

    protected Exchange sendMessage(String endpoint, final Object body) throws Exception {
        return this.template.send(endpoint, new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody(body);
            }
        });
    }

    private static class MyCustomException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private MyCustomException() {
        }
    }
}

