/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RecipientList;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class DeadLetterChannelRestartFromBeginningTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("retryBean", (Object)new RetryBean());
        return jndi;
    }

    public void testRestartFromBeginning() throws Exception {
        this.getMockEndpoint("mock:start").expectedBodiesReceived(new Object[]{"Camel", "Camel", "Camel", "Camel", "Camel"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.template.sendBody("seda:start", (Object)"Camel");
        this.setAssertPeriod(200L);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("bean:retryBean").useOriginalMessage());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(new String[]{"seda:start", "seda:retry"}).to(new String[]{"log:start", "mock:start"})).transform((Expression)this.body().prepend((Object)"Hello "))).process(new Processor(){
                    private int counter;

                    public void process(Exchange exchange) throws Exception {
                        if (this.counter++ <= 3) {
                            throw new IllegalArgumentException("Damn");
                        }
                    }
                })).to("mock:result");
            }
        };
    }

    public static class RetryBean {
        @RecipientList
        public String handleError(Exchange exchange) {
            int attempts = (Integer)exchange.getProperty("attempts", (Object)0, Integer.TYPE);
            exchange.setProperty("attempts", (Object)(++attempts));
            if (attempts <= 4) {
                return "seda:retry";
            }
            return "log:giveup";
        }
    }
}

