/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class DeadLetterChannelUseOriginalInBodyWithFileTest
extends ContextTestSupport {
    public void testOriginalInBodyIsFile() throws Exception {
        MockEndpoint dead = this.getMockEndpoint("mock:dead");
        dead.expectedMessageCount(1);
        ((ValueBuilder)dead.message(0).body()).isInstanceOf(GenericFile.class);
        ((ValueBuilder)dead.message(0).body(String.class)).isEqualTo((Object)"Hello");
        this.template.sendBodyAndHeader("file://target/originalexchange", (Object)"Hello", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        DeadLetterChannelUseOriginalInBodyWithFileTest.deleteDirectory("target/originalexchange");
        super.setUp();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead").disableRedelivery().logStackTrace(false).useOriginalMessage());
                ((RouteDefinition)this.from("file://target/originalexchange?noop=true").transform((Expression)this.body().append((Object)" World"))).process((Processor)new MyThrowProcessor());
            }
        };
    }

    public static class MyThrowProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            TestCase.assertEquals((String)"Hello World", (String)((String)exchange.getIn().getBody(String.class)));
            throw new IllegalArgumentException("Forced");
        }
    }
}

