/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class DelayInterceptorTest
extends ContextTestSupport {
    public void testSendingSomeMessages() throws Exception {
        long start = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            this.template.sendBody("direct:start", (Object)("Message #" + i));
        }
        long delta = System.currentTimeMillis() - start;
        DelayInterceptorTest.assertTrue((String)("Should not be that fast to run: " + delta), (delta > 3800L ? 1 : 0) != 0);
        DelayInterceptorTest.assertTrue((String)("Should not take that long to run: " + delta), (delta < 11000L ? 1 : 0) != 0);
    }

    @Override
    protected void setUp() throws Exception {
        this.disableJMX();
        super.setUp();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.getContext().setDelayer(Long.valueOf(200L));
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                    }
                })).to("mock:result");
            }
        };
    }
}

