/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.model.RouteDefinition;

public class Endpoint2MustBeStartedBeforeSendProcessorTest
extends ContextTestSupport {
    private MyEndpoint myendpoint;
    private volatile String order = "";

    public void testEndpointMustBeStartedBeforeProducer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint = new MyEndpoint("myendpoint", (CamelContext)Endpoint2MustBeStartedBeforeSendProcessorTest.this.context);
                this.from("direct:start").to((Endpoint)Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint);
            }
        });
        this.context.start();
        Endpoint2MustBeStartedBeforeSendProcessorTest.assertEquals((String)"EndpointProducer", (String)this.order);
    }

    public void testEndpointMustBeStartedBeforeConsumer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint = new MyEndpoint("myendpoint", (CamelContext)Endpoint2MustBeStartedBeforeSendProcessorTest.this.context);
                this.from((Endpoint)Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint).to("mock:result");
            }
        });
        this.context.start();
        Endpoint2MustBeStartedBeforeSendProcessorTest.assertEquals((String)"EndpointConsumer", (String)this.order);
    }

    public void testEndpointMustBeStartedBeforeConsumerAndProducer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint = new MyEndpoint("myendpoint", (CamelContext)Endpoint2MustBeStartedBeforeSendProcessorTest.this.context);
                ((RouteDefinition)this.from((Endpoint)Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint).to("mock:result")).to((Endpoint)Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint);
            }
        });
        this.context.start();
        Endpoint2MustBeStartedBeforeSendProcessorTest.assertEquals((String)"EndpointProducerConsumer", (String)this.order);
    }

    public void testEndpointStartedOnceAndOnlyStoppedOnShutdown() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint = new MyEndpoint("myendpoint", (CamelContext)Endpoint2MustBeStartedBeforeSendProcessorTest.this.context);
                ((RouteDefinition)this.from((Endpoint)Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint).routeId("foo").to("mock:result")).to((Endpoint)Endpoint2MustBeStartedBeforeSendProcessorTest.this.myendpoint);
            }
        });
        this.context.start();
        Endpoint2MustBeStartedBeforeSendProcessorTest.assertEquals((String)"EndpointProducerConsumer", (String)this.order);
        this.order = "";
        this.context.stopRoute("foo");
        Endpoint2MustBeStartedBeforeSendProcessorTest.assertEquals((String)"StopConsumerStopProducer", (String)this.order);
        this.order = "";
        this.context.startRoute("foo");
        Endpoint2MustBeStartedBeforeSendProcessorTest.assertEquals((String)"ProducerConsumer", (String)this.order);
        this.order = "";
        this.context.stop();
        Endpoint2MustBeStartedBeforeSendProcessorTest.assertEquals((String)"StopConsumerStopProducerStopEndpoint", (String)this.order);
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    private class MyConsumer
    extends DefaultConsumer {
        public MyConsumer(Endpoint endpoint, Processor processor) {
            super(endpoint, processor);
        }

        protected void doStart() throws Exception {
            Endpoint2MustBeStartedBeforeSendProcessorTest.this.order = Endpoint2MustBeStartedBeforeSendProcessorTest.this.order + "Consumer";
        }

        protected void doStop() throws Exception {
            Endpoint2MustBeStartedBeforeSendProcessorTest.this.order = Endpoint2MustBeStartedBeforeSendProcessorTest.this.order + "StopConsumer";
        }
    }

    private class MyProducer
    extends DefaultProducer {
        public MyProducer(Endpoint endpoint) {
            super(endpoint);
        }

        public void process(Exchange exchange) throws Exception {
        }

        protected void doStart() throws Exception {
            Endpoint2MustBeStartedBeforeSendProcessorTest.this.order = Endpoint2MustBeStartedBeforeSendProcessorTest.this.order + "Producer";
        }

        protected void doStop() throws Exception {
            Endpoint2MustBeStartedBeforeSendProcessorTest.this.order = Endpoint2MustBeStartedBeforeSendProcessorTest.this.order + "StopProducer";
        }
    }

    private final class MyEndpoint
    extends DefaultEndpoint {
        private MyEndpoint(String endpointUri, CamelContext camelContext) {
            this.setCamelContext(camelContext);
            this.setEndpointUri(endpointUri);
        }

        public Producer createProducer() throws Exception {
            return new MyProducer((Endpoint)this);
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return new MyConsumer((Endpoint)this, null);
        }

        public boolean isSingleton() {
            return true;
        }

        public void doStart() throws Exception {
            Endpoint2MustBeStartedBeforeSendProcessorTest.this.order = Endpoint2MustBeStartedBeforeSendProcessorTest.this.order + "Endpoint";
        }

        public void doStop() throws Exception {
            Endpoint2MustBeStartedBeforeSendProcessorTest.this.order = Endpoint2MustBeStartedBeforeSendProcessorTest.this.order + "StopEndpoint";
        }
    }
}

