/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ThreadsDefinition;
import org.apache.camel.processor.idempotent.MemoryIdempotentRepository;

public class IdempotentConsumerAsyncTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testDuplicateMessagesAreFilteredOut() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), MemoryIdempotentRepository.memoryIdempotentRepository((int)200)).threads().to("mock:result");
            }
        });
        this.context.start();
        this.resultEndpoint.expectedBodiesReceivedInAnyOrder(new Object[]{"one", "two", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("3", "three");
        this.assertMockEndpointsSatisfied();
    }

    public void testFailedExchangesNotAddedDeadLetterChannel() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error").maximumRedeliveries(2).redeliveryDelay(0L).logStackTrace(false));
                ((ThreadsDefinition)this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), MemoryIdempotentRepository.memoryIdempotentRepository((int)200)).threads().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String id = (String)exchange.getIn().getHeader("messageId", String.class);
                        if (id.equals("2")) {
                            throw new IllegalArgumentException("Damn I cannot handle id 2");
                        }
                    }
                })).to("mock:result");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:error").expectedMessageCount(2);
        this.resultEndpoint.expectedBodiesReceivedInAnyOrder(new Object[]{"one", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("3", "three");
        this.assertMockEndpointsSatisfied();
    }

    public void testFailedExchangesNotAdded() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((ThreadsDefinition)this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), MemoryIdempotentRepository.memoryIdempotentRepository((int)200)).threads().process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String id = (String)exchange.getIn().getHeader("messageId", String.class);
                        if (id.equals("2")) {
                            throw new IllegalArgumentException("Damn I cannot handle id 2");
                        }
                    }
                })).to("mock:result");
            }
        });
        this.context.start();
        this.resultEndpoint.expectedBodiesReceivedInAnyOrder(new Object[]{"one", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("3", "three");
        this.assertMockEndpointsSatisfied();
    }

    protected void sendMessage(final Object messageId, final Object body) throws Exception {
        this.template.send(this.startEndpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("messageId", messageId);
            }
        });
        Thread.sleep(50L);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }
}

