/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.IdempotentRepository;

public class IdempotentConsumerUsingCustomRepositoryTest
extends ContextTestSupport {
    protected Endpoint startEndpoint;
    protected MockEndpoint resultEndpoint;
    protected IdempotentRepository<String> customRepo = new MyRepo();

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").idempotentConsumer((Expression)this.header("messageId"), IdempotentConsumerUsingCustomRepositoryTest.this.customRepo).to("mock:result");
            }
        };
    }

    public void testDuplicateMessagesAreFilteredOut() throws Exception {
        this.resultEndpoint.expectedBodiesReceived(new Object[]{"one", "two", "three"});
        this.sendMessage("1", "one");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("4", "four");
        this.sendMessage("2", "two");
        this.sendMessage("1", "one");
        this.sendMessage("3", "three");
        this.assertMockEndpointsSatisfied();
        IdempotentConsumerUsingCustomRepositoryTest.assertTrue((boolean)this.customRepo.contains((Object)"1"));
        IdempotentConsumerUsingCustomRepositoryTest.assertTrue((boolean)this.customRepo.contains((Object)"2"));
        IdempotentConsumerUsingCustomRepositoryTest.assertTrue((boolean)this.customRepo.contains((Object)"3"));
        IdempotentConsumerUsingCustomRepositoryTest.assertTrue((boolean)this.customRepo.contains((Object)"4"));
        IdempotentConsumerUsingCustomRepositoryTest.assertFalse((boolean)this.customRepo.contains((Object)"5"));
    }

    protected void sendMessage(final Object messageId, final Object body) {
        this.template.send(this.startEndpoint, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("messageId", messageId);
            }
        });
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.startEndpoint = this.resolveMandatoryEndpoint("direct:start");
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    private static final class MyRepo
    implements IdempotentRepository<String> {
        private final Map<String, String> cache = new HashMap<String, String>();

        private MyRepo() {
            this.cache.put("4", "4");
        }

        public boolean add(String key) {
            if (this.cache.containsKey(key)) {
                return false;
            }
            this.cache.put(key, key);
            return true;
        }

        public boolean contains(String key) {
            return this.cache.containsKey(key);
        }

        public boolean remove(String key) {
            return this.cache.remove(key) != null;
        }

        public boolean confirm(String key) {
            return true;
        }

        public void start() throws Exception {
        }

        public void stop() throws Exception {
        }
    }
}

