/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class InheritErrorHandlerTrueTest
extends ContextTestSupport {
    private static int counter;

    public void testInheritErrorHandlerTrue() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:dead").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        InheritErrorHandlerTrueTest.assertEquals((int)3, (int)counter);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:dead").maximumRedeliveries(2).redeliveryDelay(0L));
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").process((Processor)new MyProcessor())).inheritErrorHandler(true)).to("mock:result");
            }
        };
    }

    public static class MyProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            counter++;
            exchange.setException((Throwable)new IllegalArgumentException("Damn"));
        }
    }
}

