/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class LogProcessorTest
extends ContextTestSupport {
    public void testLogProcessorFoo() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testLogProcessorBar() throws Exception {
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:bar", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    public void testLogProcessorBaz() throws Exception {
        this.getMockEndpoint("mock:baz").expectedMessageCount(1);
        this.template.sendBody("direct:baz", (Object)"Hi World");
        this.assertMockEndpointsSatisfied();
    }

    public void testLogProcessorMarker() throws Exception {
        this.getMockEndpoint("mock:wombat").expectedMessageCount(1);
        this.template.sendBody("direct:wombat", (Object)"Hi Wombat");
        this.assertMockEndpointsSatisfied();
    }

    public void testNoLog() throws Exception {
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.template.sendBody("direct:nolog", (Object)"Hi World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:foo").routeId("foo").log("Got ${body}")).to("mock:foo");
                ((RouteDefinition)this.from("direct:bar").routeId("bar").log(LoggingLevel.WARN, "Also got ${body}")).to("mock:bar");
                ((RouteDefinition)this.from("direct:baz").routeId("baz").log(LoggingLevel.ERROR, "cool", "Me got ${body}")).to("mock:baz");
                ((RouteDefinition)this.from("direct:wombat").routeId("wombat").log(LoggingLevel.INFO, "cool", "mymarker", "Me got ${body}")).to("mock:wombat");
                ((RouteDefinition)this.from("direct:nolog").routeId("nolog").log(LoggingLevel.TRACE, "Should not log ${body}")).to("mock:bar");
            }
        };
    }
}

