/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class PipelineTest
extends ContextTestSupport {
    protected MockEndpoint resultEndpoint;

    public void testSendMessageThroughAPipeline() throws Exception {
        this.resultEndpoint.expectedBodiesReceived(new Object[]{4});
        Exchange results = this.template.request("direct:a", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody((Object)1);
                in.setHeader("foo", (Object)"bar");
            }
        });
        this.resultEndpoint.assertIsSatisfied();
        PipelineTest.assertEquals((String)"Result body", (Object)4, (Object)results.getOut().getBody());
    }

    public void testResultsReturned() throws Exception {
        Exchange exchange = this.template.request("direct:b", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Hello World");
            }
        });
        PipelineTest.assertEquals((Object)"Hello World", (Object)exchange.getOut().getBody());
        PipelineTest.assertEquals((Object)3, (Object)exchange.getOut().getHeader("copy-counter"));
    }

    public void testFaultStopsPipeline() throws Exception {
        Exchange exchange = this.template.request("direct:c", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Fault Message");
            }
        });
        PipelineTest.assertTrue((exchange.getOut() != null && exchange.getOut().isFault() ? 1 : 0) != 0);
        PipelineTest.assertEquals((Object)"Fault Message", (Object)exchange.getOut().getBody());
        PipelineTest.assertEquals((Object)2, (Object)exchange.getOut().getHeader("copy-counter"));
    }

    public void testOnlyProperties() {
        Exchange exchange = this.template.request("direct:b", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setHeader("header", (Object)"headerValue");
            }
        });
        PipelineTest.assertEquals((Object)"headerValue", (Object)exchange.getOut().getHeader("header"));
        PipelineTest.assertEquals((Object)3, (Object)exchange.getOut().getHeader("copy-counter"));
    }

    public void testCopyInOutExchange() {
        Exchange exchange = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.setPattern(ExchangePattern.InOut);
                exchange.getIn().setBody((Object)"test");
            }
        });
        PipelineTest.assertEquals((String)"There should have no message header", (int)1, (int)exchange.getOut().getHeaders().size());
        PipelineTest.assertEquals((String)"There should have no attachments", (int)0, (int)exchange.getOut().getAttachments().size());
        PipelineTest.assertEquals((String)"Get a wrong message body", (Object)"test", (Object)exchange.getOut().getBody());
        PipelineTest.assertNull((Object)exchange.getOut().getHeader("test"));
        PipelineTest.assertNull((Object)exchange.getOut().getAttachment("test1.xml"));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.resultEndpoint = this.getMockEndpoint("mock:result");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        final Processor processor = new Processor(){

            public void process(Exchange exchange) {
                Integer number = (Integer)exchange.getIn().getBody(Integer.class);
                if (number == null) {
                    number = 0;
                }
                number = number + 1;
                exchange.getOut().setBody((Object)number);
            }
        };
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").pipeline(new String[]{"direct:x", "direct:y", "direct:z", "mock:result"});
                this.from("direct:x").process(processor);
                this.from("direct:y").process(processor);
                this.from("direct:z").process(processor);
                ((RouteDefinition)((RouteDefinition)this.from("direct:b").process((Processor)new InToOut())).process((Processor)new InToOut())).process((Processor)new InToOut());
                ((RouteDefinition)((RouteDefinition)this.from("direct:c").process((Processor)new InToOut())).process((Processor)new InToFault())).process((Processor)new InToOut());
                ((RouteDefinition)this.from("direct:start").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getOut().copyFrom(exchange.getIn());
                        exchange.getOut().setHeader("test", (Object)"testValue");
                        exchange.getOut().addAttachment("test1.xml", new DataHandler((DataSource)new FileDataSource("pom.xml")));
                    }
                })).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getOut().copyFrom(exchange.getIn());
                        TestCase.assertNotNull((String)"The test attachment should not be null", (Object)exchange.getOut().getAttachment("test1.xml"));
                        TestCase.assertNotNull((String)"The test header should not be null", (Object)exchange.getOut().getHeader("test"));
                        exchange.getOut().removeAttachment("test1.xml");
                        exchange.getOut().removeHeader("test");
                    }
                });
            }
        };
    }

    private static final class InToFault
    implements Processor {
        private InToFault() {
        }

        public void process(Exchange exchange) throws Exception {
            exchange.getOut().setFault(true);
            exchange.getOut().setBody(exchange.getIn().getBody());
            Integer counter = (Integer)exchange.getIn().getHeader("copy-counter", Integer.class);
            if (counter == null) {
                counter = 0;
            }
            exchange.getOut().setHeader("copy-counter", (Object)(counter + 1));
        }
    }

    private static final class InToOut
    implements Processor {
        private InToOut() {
        }

        public void process(Exchange exchange) throws Exception {
            exchange.getOut().copyFrom(exchange.getIn());
            Integer counter = (Integer)exchange.getIn().getHeader("copy-counter", Integer.class);
            if (counter == null) {
                counter = 0;
            }
            exchange.getOut().setHeader("copy-counter", (Object)(counter + 1));
        }
    }
}

