/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.MySentEventNotifier;
import org.apache.camel.spi.EventNotifier;

public class ProducerTemplateDisableEventNotifierTest
extends ContextTestSupport {
    private MySentEventNotifier notifier = new MySentEventNotifier();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = (DefaultCamelContext)super.createCamelContext();
        context.getManagementStrategy().addEventNotifier((EventNotifier)this.notifier);
        return context;
    }

    public void testExchangeSent() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ProducerTemplate other = this.context.createProducerTemplate();
        other.setEventNotifierEnabled(false);
        other.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        ProducerTemplateDisableEventNotifierTest.assertEquals((int)2, (int)this.notifier.getEvents().size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").to("direct:bar")).to("mock:result");
                this.from("direct:bar").delay(1L);
            }
        };
    }
}

