/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class RecipientListNoCacheTest
extends ContextTestSupport {
    public void testNoCache() throws Exception {
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{"foo", "bar"});
        y.expectedBodiesReceived(new Object[]{"foo", "bar"});
        z.expectedBodiesReceived(new Object[]{"foo", "bar"});
        this.sendBody("foo");
        this.sendBody("bar");
        this.assertMockEndpointsSatisfied();
    }

    protected void sendBody(String body) {
        this.template.sendBodyAndHeader("direct:a", (Object)body, "recipientListHeader", (Object)"mock:x,mock:y,mock:z");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").recipientList((Expression)this.header("recipientListHeader").tokenize(",")).cacheSize(0);
            }
        };
    }
}

