/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RecipientList;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.InterceptStrategy;

public class RecipientListReturnValueTest
extends ContextTestSupport {
    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myBean", (Object)new MyBean());
        return jndi;
    }

    public void testRecipientListWithRecipientList() throws Exception {
        this.doTestRecipientList("direct:recipientList");
    }

    public void testRecipientListWithBeanRef() throws Exception {
        this.doTestRecipientList("direct:beanRef");
    }

    private void doTestRecipientList(String uri) throws InterruptedException {
        MockEndpoint a = this.getMockEndpoint("mock:a");
        a.expectedBodiesReceived(new Object[]{"Hello a"});
        MockEndpoint b = this.getMockEndpoint("mock:b");
        b.expectedBodiesReceived(new Object[]{"Hello b"});
        String out = (String)this.template.requestBody(uri, (Object)("Hello " + uri), String.class);
        RecipientListReturnValueTest.assertEquals((String)"Hello b", (String)out);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.getContext().addInterceptStrategy((InterceptStrategy)new Tracer());
                this.from("direct:beanRef").beanRef("myBean", "route");
                this.from("direct:recipientList").recipientList().method("myBean", "recipientList");
                ((RouteDefinition)this.from("direct:a").transform((Expression)this.constant("Hello a"))).to("mock:a");
                ((RouteDefinition)this.from("direct:b").transform((Expression)this.constant("Hello b"))).to("mock:b");
            }
        };
    }

    public class MyBean {
        @RecipientList
        public String[] route() {
            return new String[]{"direct:a", "direct:b"};
        }

        public String[] recipientList() {
            return new String[]{"direct:a", "direct:b"};
        }
    }
}

