/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.builder.RouteBuilder;

public class RollbackCustomMessageTest
extends ContextTestSupport {
    public void testRollbackCustomMessage() throws Exception {
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            RollbackCustomMessageTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            RollbackCustomMessageTest.assertIsInstanceOf(RollbackExchangeException.class, e.getCause());
            RollbackCustomMessageTest.assertEquals((String)"boo. Exchange[Message: Hello World]", (String)e.getCause().getMessage());
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                RollbackCustomMessageTest.this.context.setTracing(Boolean.valueOf(true));
                this.from("direct:start").rollback("boo");
            }
        };
    }
}

