/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;

public class SplitterParallelBigFileTest
extends ContextTestSupport {
    private int lines = 20000;

    @Override
    protected void setUp() throws Exception {
        SplitterParallelBigFileTest.deleteDirectory("target/split");
        SplitterParallelBigFileTest.createDirectory("target/split");
        this.createBigFile();
        super.setUp();
    }

    private void createBigFile() throws Exception {
        File file = new File("target/split/bigfile.txt");
        FileOutputStream fos = new FileOutputStream(file);
        for (int i = 0; i < this.lines; ++i) {
            String line = "line-" + i + LS;
            fos.write(line.getBytes());
        }
        IOHelper.close((Closeable)fos);
    }

    public void testNoop() {
    }

    public void xxxtestSplitParallelBigFile() throws Exception {
        StopWatch watch = new StopWatch();
        NotifyBuilder builder = new NotifyBuilder((CamelContext)this.context).whenDone(this.lines + 1).create();
        boolean done = builder.matches(120L, TimeUnit.SECONDS);
        this.log.info("Took " + TimeUtils.printDuration((double)watch.stop()));
        if (!done) {
            throw new CamelException("Could not split file in 2 minutes");
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)this.from("file:target/split").split((Expression)this.body().tokenize(LS)).streaming().parallelProcessing().to("log:split?groupSize=1000")).end().log("Done splitting ${file:name}");
            }
        };
    }
}

