/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.Builder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.processor.Throttler;
import org.apache.camel.processor.ThrottlerRejectedExecutionException;

public class ThrottlerTest
extends ContextTestSupport {
    private static final int INTERVAL = 500;
    protected int messageCount = 9;

    protected boolean canTest() {
        return !ThrottlerTest.isPlatform("windows");
    }

    public void testSendLotsOfMessagesButOnly3GetThrough() throws Exception {
        if (!this.canTest()) {
            return;
        }
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(3);
        resultEndpoint.setResultWaitTime(2000L);
        for (int i = 0; i < this.messageCount; ++i) {
            this.template.sendBody("seda:a", (Object)("<message>" + i + "</message>"));
        }
        resultEndpoint.assertIsSatisfied();
    }

    public void testSendLotsOfMessagesWithRejctExecution() throws Exception {
        if (!this.canTest()) {
            return;
        }
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(2);
        resultEndpoint.setResultWaitTime(2000L);
        MockEndpoint errorEndpoint = this.resolveMandatoryEndpoint("mock:error", MockEndpoint.class);
        errorEndpoint.expectedMessageCount(4);
        errorEndpoint.setResultWaitTime(2000L);
        for (int i = 0; i < 6; ++i) {
            this.template.sendBody("direct:start", (Object)("<message>" + i + "</message>"));
        }
        resultEndpoint.assertIsSatisfied();
        errorEndpoint.assertIsSatisfied();
    }

    public void testSendLotsOfMessagesSimultaneouslyButOnly3GetThrough() throws Exception {
        if (!this.canTest()) {
            return;
        }
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(this.messageCount);
        ExecutorService executor = Executors.newFixedThreadPool(this.messageCount);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.messageCount; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ThrottlerTest.this.template.sendBody("direct:a", (Object)"<message>payload</message>");
                }
            });
        }
        resultEndpoint.assertIsSatisfied();
        long minimumTime = (this.messageCount - 1) * 500;
        long delta = System.currentTimeMillis() - start + 750L;
        ThrottlerTest.assertTrue((String)("Should take at least " + minimumTime + "ms, was: " + delta), (delta >= minimumTime ? 1 : 0) != 0);
        executor.shutdownNow();
    }

    public void testTimeSlotCalculus() throws Exception {
        if (!this.canTest()) {
            return;
        }
        Throttler throttler = new Throttler((CamelContext)this.context, null, (Expression)Builder.constant((Object)3), 1000L, null, false, false);
        throttler.calculateDelay((Exchange)new DefaultExchange((CamelContext)this.context));
        Throttler.TimeSlot slot = throttler.nextSlot();
        ThrottlerTest.assertNotNull((Object)slot);
        ThrottlerTest.assertSame((Object)slot, (Object)throttler.nextSlot());
        ThrottlerTest.assertTrue((boolean)slot.isFull());
        ThrottlerTest.assertTrue((boolean)slot.isActive());
        Throttler.TimeSlot next = throttler.nextSlot();
        ThrottlerTest.assertNotSame((Object)slot, (Object)next);
        ThrottlerTest.assertFalse((boolean)next.isActive());
    }

    public void testTimeSlotCalculusForPeriod() throws InterruptedException {
        if (!this.canTest()) {
            return;
        }
        Throttler throttler = new Throttler((CamelContext)this.context, null, (Expression)Builder.constant((Object)3), 1000L, null, false, false);
        throttler.calculateDelay((Exchange)new DefaultExchange((CamelContext)this.context));
        Throttler.TimeSlot slot = throttler.getSlot();
        ThrottlerTest.assertNotNull((Object)slot);
        ThrottlerTest.assertSame((Object)slot, (Object)throttler.nextSlot());
        Thread.sleep(1500L);
        ThrottlerTest.assertFalse((boolean)slot.isActive());
        ThrottlerTest.assertNotSame((Object)slot, (Object)throttler.nextSlot());
    }

    public void testConfigurationWithConstantExpression() throws Exception {
        if (!this.canTest()) {
            return;
        }
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(this.messageCount);
        ExecutorService executor = Executors.newFixedThreadPool(this.messageCount);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.messageCount; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ThrottlerTest.this.template.sendBody("direct:expressionConstant", (Object)"<message>payload</message>");
                }
            });
        }
        resultEndpoint.assertIsSatisfied();
        long minimumTime = (this.messageCount - 1) * 500;
        long delta = System.currentTimeMillis() - start + 200L;
        ThrottlerTest.assertTrue((String)("Should take at least " + minimumTime + "ms, was: " + delta), (delta >= minimumTime ? 1 : 0) != 0);
        executor.shutdownNow();
    }

    public void testConfigurationWithHeaderExpression() throws Exception {
        if (!this.canTest()) {
            return;
        }
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        resultEndpoint.expectedMessageCount(this.messageCount);
        ExecutorService executor = Executors.newFixedThreadPool(this.messageCount);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.messageCount; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ThrottlerTest.this.template.sendBodyAndHeader("direct:expressionHeader", (Object)"<message>payload</message>", "throttleValue", (Object)1);
                }
            });
        }
        resultEndpoint.assertIsSatisfied();
        long minimumTime = (this.messageCount - 1) * 500;
        long delta = System.currentTimeMillis() - start + 200L;
        ThrottlerTest.assertTrue((String)("Should take at least " + minimumTime + "ms, was: " + delta), (delta >= minimumTime ? 1 : 0) != 0);
        executor.shutdownNow();
    }

    public void testConfigurationWithChangingHeaderExpression() throws Exception {
        if (!this.canTest()) {
            return;
        }
        ExecutorService executor = Executors.newFixedThreadPool(this.messageCount);
        MockEndpoint resultEndpoint = this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        this.sendMessagesWithHeaderExpression(executor, resultEndpoint, 1);
        resultEndpoint.reset();
        this.sendMessagesWithHeaderExpression(executor, resultEndpoint, 10);
        resultEndpoint.reset();
        this.sendMessagesWithHeaderExpression(executor, resultEndpoint, 1);
        executor.shutdownNow();
    }

    private void sendMessagesWithHeaderExpression(ExecutorService executor, MockEndpoint resultEndpoint, final int throttle) throws InterruptedException {
        resultEndpoint.expectedMessageCount(this.messageCount);
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.messageCount; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ThrottlerTest.this.template.sendBodyAndHeader("direct:expressionHeader", (Object)"<message>payload</message>", "throttleValue", (Object)throttle);
                }
            });
        }
        resultEndpoint.assertIsSatisfied();
        long minimumTime = (this.messageCount - 1) * 500 / throttle;
        long delta = System.currentTimeMillis() - start + 200L;
        ThrottlerTest.assertTrue((String)("Should take at least " + minimumTime + "ms, was: " + delta), (delta >= minimumTime ? 1 : 0) != 0);
        long maxTime = (this.messageCount - 1) * 500 / throttle * 3;
        ThrottlerTest.assertTrue((String)("Should take at most " + maxTime + "ms, was: " + delta), (delta <= maxTime ? 1 : 0) != 0);
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.onException(ThrottlerRejectedExecutionException.class).handled(true).to("mock:error");
                this.from("seda:a").throttle(3L).timePeriodMillis(10000L).to(new String[]{"log:result", "mock:result"});
                this.from("direct:a").throttle(1L).timePeriodMillis(500L).to(new String[]{"log:result", "mock:result"});
                this.from("direct:expressionConstant").throttle((Expression)this.constant(1)).timePeriodMillis(500L).to(new String[]{"log:result", "mock:result"});
                this.from("direct:expressionHeader").throttle((Expression)this.header("throttleValue")).timePeriodMillis(500L).to(new String[]{"log:result", "mock:result"});
                this.from("direct:start").throttle(2L).timePeriodMillis(10000L).rejectExecution(true).to(new String[]{"log:result", "mock:result"});
            }
        };
    }
}

