/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.TryDefinition;

public class TryCatchCaughtExceptionTwoTimesTest
extends ContextTestSupport {
    public void testTryCatchCaughtException() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myBean", (Object)this);
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("mock:a")).to("bean:myBean?method=doSomething")).doCatch(Exception.class).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertEquals((Object)"bean://myBean?method=doSomething", (Object)exchange.getProperty("CamelFailureEndpoint"));
                        TestCase.assertEquals((String)"Forced", (String)((Exception)exchange.getProperty("CamelExceptionCaught", Exception.class)).getMessage());
                    }
                })).end().to("mock:b").doTry().to("mock:c")).to("bean:myBean?method=doSomethingElse")).doCatch(Exception.class).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        TestCase.assertEquals((Object)"bean://myBean?method=doSomethingElse", (Object)exchange.getProperty("CamelFailureEndpoint"));
                        TestCase.assertEquals((String)"Forced Again", (String)((Exception)exchange.getProperty("CamelExceptionCaught", Exception.class)).getMessage());
                    }
                })).end().to("mock:result");
            }
        };
    }

    public void doSomething(String body) throws Exception {
        throw new IllegalArgumentException("Forced");
    }

    public void doSomethingElse(String body) throws Exception {
        throw new IllegalArgumentException("Forced Again");
    }
}

