/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.management.event.ExchangeCompletedEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.EventNotifierSupport;

public class UnitOfWorkProducerTest
extends ContextTestSupport {
    private static List<EventObject> events = new ArrayList<EventObject>();

    @Override
    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)this.createRegistry());
        context.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

            public void notify(EventObject event) throws Exception {
                events.add(event);
            }

            public boolean isEnabled(EventObject event) {
                return event instanceof ExchangeCompletedEvent;
            }

            protected void doStart() throws Exception {
            }

            protected void doStop() throws Exception {
            }
        });
        return context;
    }

    @Override
    protected void tearDown() throws Exception {
        events.clear();
        super.tearDown();
    }

    public void testSedaBasedUnitOfWorkProducer() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        UnitOfWorkProducerTest.assertEquals((int)2, (int)events.size());
    }

    public void testDirectBasedUnitOfWorkProducer() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        UnitOfWorkProducerTest.assertEquals((int)1, (int)events.size());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo").to("mock:result");
                this.from("direct:bar").to("mock:result");
            }
        };
    }
}

