/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.WireTapDefinition;

public class WireTapTest
extends ContextTestSupport {
    protected MockEndpoint tap;
    protected MockEndpoint result;

    public void testSend() throws Exception {
        this.result.expectedBodiesReceived(new Object[]{"Hello World", "Tapped"});
        this.tap.expectedBodiesReceived(new Object[]{"Tapped"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testWireTapId() throws Exception {
        MockEndpoint a = this.getMockEndpoint("mock:a");
        MockEndpoint b = this.getMockEndpoint("mock:b");
        a.expectedBodiesReceived(new Object[]{"Hello"});
        b.expectedBodiesReceived(new Object[]{"Hello"});
        this.template.sendBody("direct:test", (Object)"Hello");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.tap = this.getMockEndpoint("mock:tap");
        this.result = this.getMockEndpoint("mock:result");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("log:foo")).wireTap("direct:tap").to("mock:result");
                ((ProcessorDefinition)this.from("direct:tap").delay(1000L).setBody().constant((Object)"Tapped")).to(new String[]{"mock:result", "mock:tap"});
                ((WireTapDefinition)this.from("direct:test").wireTap("direct:a").id("wiretap_1")).to("mock:a");
                this.from("direct:a").to("mock:b");
            }
        };
    }
}

