/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;

public class XPathChoiceTest
extends ContextTestSupport {
    protected MockEndpoint x;
    protected MockEndpoint y;
    protected MockEndpoint z;

    public void testSendToFirstWhen() throws Exception {
        String body = "<body id='a'/>";
        this.x.expectedBodiesReceived(new Object[]{body});
        MockEndpoint.expectsMessageCount((int)0, (MockEndpoint[])new MockEndpoint[]{this.y, this.z});
        this.sendMessage("bar", body);
        this.assertMockEndpointsSatisfied();
    }

    public void testSendToSecondWhen() throws Exception {
        String body = "<body id='b'/>";
        this.y.expectedBodiesReceived(new Object[]{body});
        MockEndpoint.expectsMessageCount((int)0, (MockEndpoint[])new MockEndpoint[]{this.x, this.z});
        this.sendMessage("cheese", body);
        this.assertMockEndpointsSatisfied();
    }

    public void testSendToOtherwiseClause() throws Exception {
        String body = "<body id='c'/>";
        this.z.expectedBodiesReceived(new Object[]{body});
        MockEndpoint.expectsMessageCount((int)0, (MockEndpoint[])new MockEndpoint[]{this.x, this.y});
        this.sendMessage("somethingUndefined", body);
        this.assertMockEndpointsSatisfied();
    }

    protected void sendMessage(Object headerValue, Object body) throws Exception {
        this.template.sendBodyAndHeader("direct:start", body, "foo", headerValue);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.x = this.getMockEndpoint("mock:x");
        this.y = this.getMockEndpoint("mock:y");
        this.z = this.getMockEndpoint("mock:z");
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when().xpath("/body[@id='a']")).setHeader("name", (Expression)this.constant("a"))).to("mock:x")).when().xpath("/body[@id='b']")).to("mock:y")).otherwise().to("mock:z");
            }
        };
    }
}

