/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.InterceptStrategy;

public class AsyncEndpointCustomAsyncInterceptorTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;
    private MyInterceptor interceptor = new MyInterceptor();

    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedBodiesReceived(new Object[]{"Bye Camel"});
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"Bye Camel"});
        String reply = (String)this.template.requestBody("direct:start", (Object)"Hello Camel", String.class);
        AsyncEndpointCustomAsyncInterceptorTest.assertEquals((String)"Bye Camel", (String)reply);
        this.assertMockEndpointsSatisfied();
        AsyncEndpointCustomAsyncInterceptorTest.assertEquals((int)8, (int)this.interceptor.getCounter());
        AsyncEndpointCustomAsyncInterceptorTest.assertFalse((String)"Should use different threads", (boolean)beforeThreadName.equalsIgnoreCase(afterThreadName));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointCustomAsyncInterceptorTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                AsyncEndpointCustomAsyncInterceptorTest.this.context.addInterceptStrategy((InterceptStrategy)AsyncEndpointCustomAsyncInterceptorTest.this.interceptor);
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:before")).to("log:before")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).to("async:bye:camel")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        afterThreadName = Thread.currentThread().getName();
                    }
                })).to("log:after")).to("mock:after")).to("mock:result");
            }
        };
    }

    private static class MyInterceptor
    implements InterceptStrategy {
        private AtomicInteger counter = new AtomicInteger();

        private MyInterceptor() {
        }

        public Processor wrapProcessorInInterceptors(CamelContext context, ProcessorDefinition<?> definition, Processor target, Processor nextTarget) throws Exception {
            return new DelegateAsyncProcessor(target){

                public boolean process(Exchange exchange, AsyncCallback callback) {
                    MyInterceptor.this.counter.incrementAndGet();
                    return this.processor.process(exchange, callback);
                }
            };
        }

        public int getCounter() {
            return this.counter.get();
        }
    }
}

