/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;
import org.apache.camel.spi.Policy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.AsyncProcessorHelper;

public class AsyncEndpointPolicyTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyPolicy("foo"));
        return jndi;
    }

    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedHeaderReceived("foo", (Object)"was wrapped");
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedHeaderReceived("foo", (Object)"was wrapped");
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedHeaderReceived("foo", (Object)"was wrapped");
        this.getMockEndpoint("mock:response").expectedMessageCount(1);
        this.getMockEndpoint("mock:response").expectedHeaderReceived("foo", (Object)"policy finished execution");
        this.template.sendBody("direct:send", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MyPolicy foo = (MyPolicy)this.context.getRegistry().lookupByNameAndType("foo", MyPolicy.class);
        AsyncEndpointPolicyTest.assertEquals((String)"Should only be invoked 1 time", (int)1, (int)foo.getInvoked());
        AsyncEndpointPolicyTest.assertFalse((String)"Should use different threads", (boolean)beforeThreadName.equalsIgnoreCase(afterThreadName));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointPolicyTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((PolicyDefinition)((PolicyDefinition)((PolicyDefinition)this.from("direct:start").policy("foo").to("mock:foo")).to("async:bye:camel")).to("mock:bar")).to("mock:result");
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:send").to("mock:before")).to("log:before")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).to("direct:start")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        afterThreadName = Thread.currentThread().getName();
                    }
                })).to("log:after")).to("mock:after")).to("mock:response");
            }
        };
    }

    public static class MyPolicy
    implements Policy {
        private final String name;
        private int invoked;

        public MyPolicy(String name) {
            this.name = name;
        }

        public void beforeWrap(RouteContext routeContext, ProcessorDefinition<?> definition) {
        }

        public Processor wrap(RouteContext routeContext, final Processor processor) {
            return new AsyncProcessor(){

                public boolean process(final Exchange exchange, final AsyncCallback callback) {
                    MyPolicy.this.invoked++;
                    exchange.getIn().setHeader(MyPolicy.this.name, (Object)"was wrapped");
                    AsyncProcessor ap = AsyncProcessorConverterHelper.convert((Processor)processor);
                    boolean sync = ap.process(exchange, new AsyncCallback(){

                        public void done(boolean doneSync) {
                            if (doneSync) {
                                return;
                            }
                            exchange.getIn().setHeader(MyPolicy.this.name, (Object)"policy finished execution");
                            callback.done(false);
                        }
                    });
                    if (!sync) {
                        return false;
                    }
                    exchange.getIn().setHeader(MyPolicy.this.name, (Object)"policy finished execution");
                    callback.done(true);
                    return true;
                }

                public void process(Exchange exchange) throws Exception {
                    AsyncProcessorHelper.process((AsyncProcessor)this, (Exchange)exchange);
                }
            };
        }

        public int getInvoked() {
            return this.invoked;
        }
    }
}

