/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import junit.framework.TestCase;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;

public class AsyncEndpointRecipientListFineGrainedErrorHandlingTest
extends ContextTestSupport {
    private static int counter;

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("fail", (Object)new MyFailBean());
        return jndi;
    }

    public void testAsyncEndpointOK() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointRecipientListFineGrainedErrorHandlingTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                this.onException(Exception.class).maximumRedeliveries(2);
                ((RouteDefinition)this.from("direct:start").to("mock:a")).recipientList((Expression)this.header("foo")).stopOnException();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"mock:foo,async:bye:camel,mock:bar,mock:baz");
        this.assertMockEndpointsSatisfied();
    }

    public void testAsyncEndpointERROR() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointRecipientListFineGrainedErrorHandlingTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                this.onException(Exception.class).maximumRedeliveries(2);
                ((RouteDefinition)this.from("direct:start").to("mock:a")).recipientList((Expression)this.header("foo")).stopOnException();
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:baz").expectedMessageCount(0);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"mock:foo,mock:bar,bean:fail,mock:baz");
            AsyncEndpointRecipientListFineGrainedErrorHandlingTest.fail((String)"Should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
        AsyncEndpointRecipientListFineGrainedErrorHandlingTest.assertEquals((int)3, (int)counter);
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public static class MyFailBean {
        public String doSomething(Exchange exchange) throws Exception {
            counter++;
            TestCase.assertEquals((String)"bean://fail", (String)((String)exchange.getProperty("CamelToEndpoint", String.class)));
            throw new IllegalArgumentException("Damn");
        }
    }
}

