/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.async;

import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.async.MyAsyncComponent;

public class AsyncEndpointWithHandleFaultTest
extends ContextTestSupport {
    private static String beforeThreadName;
    private static String afterThreadName;

    public void testAsyncEndpoint() throws Exception {
        this.getMockEndpoint("mock:before").expectedBodiesReceived(new Object[]{"Hello Camel"});
        this.getMockEndpoint("mock:after").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        Exchange reply = this.template.request("direct:start", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getIn().setBody((Object)"Hello Camel");
            }
        });
        AsyncEndpointWithHandleFaultTest.assertNotNull((Object)reply);
        AsyncEndpointWithHandleFaultTest.assertTrue((boolean)reply.isFailed());
        AsyncEndpointWithHandleFaultTest.assertNotNull((Object)reply.getException());
        AsyncEndpointWithHandleFaultTest.assertEquals((String)"Faulty Bye Camel", (String)reply.getException().getMessage());
        this.assertMockEndpointsSatisfied();
        AsyncEndpointWithHandleFaultTest.assertFalse((String)"Should use different threads", (boolean)beforeThreadName.equalsIgnoreCase(afterThreadName));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                AsyncEndpointWithHandleFaultTest.this.context.addComponent("async", (Component)new MyAsyncComponent());
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").handleFault().to("mock:before")).to("log:before")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        beforeThreadName = Thread.currentThread().getName();
                    }
                })).to("async:bye:camel")).to("log:after")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        afterThreadName = Thread.currentThread().getName();
                        exchange.getOut().setFault(true);
                        exchange.getOut().setBody((Object)"Faulty Bye Camel");
                    }
                })).to("mock:after")).to("mock:result");
            }
        };
    }
}

