/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.enricher;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.processor.aggregate.UseLatestAggregationStrategy;

public class EnricherRefTest
extends ContextTestSupport {
    private MockEndpoint cool = new MockEndpoint("mock:cool");

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("cool", (Object)this.cool);
        jndi.bind("agg", (Object)new UseLatestAggregationStrategy());
        return jndi;
    }

    public void testEnrichRef() throws Exception {
        this.cool.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getOut().setBody((Object)"Bye World");
            }
        });
        this.cool.expectedBodiesReceived(new Object[]{"Hello World"});
        String out = (String)this.template.requestBody("direct:start", (Object)"Hello World", String.class);
        EnricherRefTest.assertEquals((String)"Bye World", (String)out);
        this.cool.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                EnricherRefTest.this.cool.setCamelContext((CamelContext)EnricherRefTest.this.context);
                this.from("direct:start").enrichRef("cool", "agg");
            }
        };
    }
}

