/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.exceptionpolicy;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class DefaultExceptionPolicyStrategyUsingOnlyWhenTest
extends ContextTestSupport {
    private static final String ERROR_QUEUE = "mock:error";
    private static final String ERROR_USER_QUEUE = "mock:usererror";

    public void testNoWhen() throws Exception {
        MockEndpoint mock = this.getMockEndpoint(ERROR_QUEUE);
        mock.expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:a", (Object)"Hello Camel");
        this.assertMockEndpointsSatisfied();
    }

    public void testWithWhen() throws Exception {
        MockEndpoint mock = this.getMockEndpoint(ERROR_USER_QUEUE);
        mock.expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBodyAndHeader("direct:a", (Object)"Hello Camel", "user", (Object)"admin");
            DefaultExceptionPolicyStrategyUsingOnlyWhenTest.fail((String)"Should have thrown an Exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel(DefaultExceptionPolicyStrategyUsingOnlyWhenTest.ERROR_QUEUE).maximumRedeliveries(0).redeliveryDelay(100L));
                this.onException(MyUserException.class).onWhen(this.header("user").isNotNull()).maximumRedeliveries(1).backOffMultiplier(2.0).redeliveryDelay(0L).to(DefaultExceptionPolicyStrategyUsingOnlyWhenTest.ERROR_USER_QUEUE);
                ((RouteDefinition)this.from("direct:a").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        String s = (String)exchange.getIn().getBody(String.class);
                        if ("Hello Camel".equals(s)) {
                            throw new MyUserException("Forced for testing");
                        }
                        exchange.getOut().setBody((Object)"Hello World");
                    }
                })).to("mock:result");
            }
        };
    }

    public static class MyUserException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MyUserException(String message) {
            super(message);
        }
    }
}

