/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.InterceptDefinition;

public class InterceptFromSimpleRouteTest
extends ContextTestSupport {
    public void testIntercept() throws Exception {
        MockEndpoint intercepted = this.getMockEndpoint("mock:intercepted");
        intercepted.expectedBodiesReceived(new Object[]{"Hello London"});
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Hello Paris"});
        this.template.sendBodyAndHeader("seda:a", (Object)"Hello London", "city", (Object)"London");
        this.template.sendBodyAndHeader("seda:a", (Object)"Hello Paris", "city", (Object)"Paris");
        intercepted.assertIsSatisfied();
        result.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((InterceptDefinition)this.interceptFrom().when(this.header("city").isEqualTo((Object)"London")).to("mock:intercepted")).stop();
                this.from("seda:a").to("mock:result");
            }
        };
    }
}

