/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;

public class InterceptFromWhenWithChoiceTest
extends ContextTestSupport {
    public void testInterceptorHelloWorld() throws Exception {
        this.getMockEndpoint("mock:goofy").expectedMessageCount(0);
        this.getMockEndpoint("mock:hello").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:end").expectedMessageCount(1);
        this.sendBody("direct:start", "Hello World!");
        this.assertMockEndpointsSatisfied();
    }

    public void testInterceptorHelloGoofy() throws Exception {
        this.getMockEndpoint("mock:goofy").expectedMessageCount(0);
        this.getMockEndpoint("mock:hello").expectedMessageCount(1);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:end").expectedMessageCount(0);
        this.sendBody("direct:start", "Hello Goofy");
        this.assertMockEndpointsSatisfied();
    }

    public void testInterceptorByeGoofy() throws Exception {
        this.getMockEndpoint("mock:goofy").expectedMessageCount(1);
        this.getMockEndpoint("mock:hello").expectedMessageCount(0);
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:end").expectedMessageCount(0);
        this.sendBody("direct:start", "Bye Goofy");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.interceptFrom().when((Predicate)this.simple("${body} contains 'Goofy'")).choice().when(this.body().contains((Object)"Hello")).to("mock:hello")).otherwise().to("log:foo")).to("mock:goofy")).end().stop();
                ((RouteDefinition)this.from("direct:start").to("mock:foo")).to("mock:end");
            }
        };
    }
}

