/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.intercept;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.InterceptDefinition;

public class InterceptSimpleRouteWhenStopTest
extends ContextTestSupport {
    public void testInterceptStop() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(0);
        this.getMockEndpoint("mock:bar").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:intercepted").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testInterceptNoStop() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:bar").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:intercepted").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hi");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((InterceptDefinition)this.intercept().when(this.body().contains((Object)"Hello")).to("mock:intercepted")).stop();
                this.from("direct:start").to(new String[]{"mock:foo", "mock:bar", "mock:result"});
            }
        };
    }
}

