/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.onexception;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.onexception.MyFunctionalException;
import org.apache.camel.processor.onexception.MyServiceBean;
import org.apache.camel.processor.onexception.MyTechnicalException;

public class OnExceptionFromChoiceUseOriginalBodyTest
extends ContextTestSupport {
    private MyServiceBean myServiceBean;

    public void testNoErrorWhen() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:func").expectedMessageCount(0);
        this.getMockEndpoint("mock:tech").expectedMessageCount(0);
        this.getMockEndpoint("mock:otherwise").expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint("mock:when");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:route", (Object)"<order><type>myType</type><user>James</user></order>");
        this.assertMockEndpointsSatisfied();
    }

    public void testFunctionalError() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:tech").expectedMessageCount(0);
        this.getMockEndpoint("mock:when").expectedMessageCount(0);
        this.getMockEndpoint("mock:otherwise").expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint("mock:func");
        mock.expectedBodiesReceived(new Object[]{"Func"});
        this.template.sendBody("direct:func", (Object)"Func");
        this.assertMockEndpointsSatisfied();
    }

    public void testTechnicalError() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:func").expectedMessageCount(0);
        this.getMockEndpoint("mock:when").expectedMessageCount(0);
        this.getMockEndpoint("mock:otherwise").expectedMessageCount(0);
        MockEndpoint mock = this.getMockEndpoint("mock:tech");
        mock.expectedBodiesReceived(new Object[]{"Tech"});
        this.template.sendBody("direct:tech", (Object)"Tech");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        this.myServiceBean = new MyServiceBean();
        super.setUp();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myServiceBean", (Object)this.myServiceBean);
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.errorHandler((ErrorHandlerBuilder)this.deadLetterChannel("mock:error"));
                this.onException(MyTechnicalException.class).useOriginalMessage().maximumRedeliveries(0).handled(true).to("mock:tech");
                this.onException(MyFunctionalException.class).useOriginalMessage().maximumRedeliveries(0).handled(true).to("mock:func");
                ((RouteDefinition)this.from("direct:tech").setBody((Expression)this.constant("<order><type>myType</type><user>Tech</user></order>"))).to("direct:route");
                ((RouteDefinition)this.from("direct:func").setBody((Expression)this.constant("<order><type>myType</type><user>Func</user></order>"))).to("direct:route");
                ((ChoiceDefinition)this.from("direct:route").choice().when(this.method("myServiceBean").isEqualTo((Object)"James")).to("mock:when")).otherwise().to("mock:otherwise");
            }
        };
    }
}

