/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.routingslip;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutingSlip;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class RoutingSlipPOJOTest
extends ContextTestSupport {
    public void testRoutingSlipPOJO() throws Exception {
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        MockEndpoint result = this.getMockEndpoint("mock:result");
        foo.expectedBodiesReceived(new Object[]{"Message"});
        result.expectedBodiesReceived(new Object[]{"Message is processed!"});
        this.template.sendBody("direct:a", (Object)"Message");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").bean((Object)new MyRoutingSlipPOJO());
                this.from("direct:b").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getOut().setBody((Object)(exchange.getIn().getBody() + " is processed!"));
                    }
                });
            }
        };
    }

    public class MyRoutingSlipPOJO {
        @RoutingSlip(context="camel-1")
        public String[] doSomething(String body) {
            return new String[]{"mock:foo", "direct:b", "mock:result"};
        }
    }
}

